<?php
class vB_ProfileBlock_umgprofile extends vB_ProfileBlock
{
	var $template_name = 'memberinfo_block_umgprofile';

	function confirm_empty_wrap ()
	{
		return false;
	}

	function confirm_display ()
	{
		return ($this->block_data['umg_profile'] != '');
	}

	function prepare_output ($id = '', $options = array())
	{
		global $stylevar, $db, $vbulletin, $vbphrase, $permissions, $userinfo, $session;

		unset ($tpl_output);

		$ok = 1;
		if (!($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canuseumg'])) $ok = 0;
		if (
			(!($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canhavepublic'])) AND 
			(!($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canseeprivate']))
		) $ok = 0;

		$only_private = '';
		$usettings = unserialize ($vbulletin->umg_psettings);
		if (!empty ($usettings) AND $usettings['media_count'] > 1)
		{
			if ($usettings['only_private'])
			{
				$only_private = "AND ca.userid=" . $userinfo['userid'];
				// get only private but without permission doesn't show anything
				if (!($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canseeprivate'])) $ok = 0;
			}
			else
			{
				// we get all categories but haven't permission for private
				if (!($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canseeprivate'])) $only_private = "AND ca.userid=0";
				// if we haven't permission for the public gallery show only private
				if (!($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canhavepublic'])) $only_private = "AND ca.userid=" . $userinfo['userid'];
			}
		}

		if ($ok)
		{
			require (DIR . '/umg_gallery/umg_permissions.php');

			if (!empty ($usettings) AND $usettings['media_count'] > 1)
			{
				$and_query = $media_profile_bit = '';

				$order_by = 'ORDER BY m.dateline DESC ';
				if ($usettings['sort_by'] == 1)
				{
					$and_query = 'AND m.votenum>0 ';
					$order_by = 'ORDER BY AVG(m.votetotal / m.votenum) DESC ';
				}
				else if ($usettings['sort_by'] == 2)
				{
					$and_query = 'AND m.counter>0 ';
					$order_by = 'ORDER BY m.counter DESC ';
				}
				else if ($usettings['sort_by'] == 3)
				{
					$and_query = 'AND c.comid>0 ';
					$order_by = 'ORDER BY comcount DESC ';
				}

				$profile['info'] = false;
				if ($usettings['show_info']) $profile['info'] = true;

				$size = $usettings['media_size'];
				$media_row = $usettings['media_row'];
				if ($media_row <= 0) $media_row = 1;

				$medias = $db->query_read ("SELECT 
					m.*,COUNT(c.comid) AS comcount,ca.title AS cattitle,ca.userid AS gallery,ca.permission,ca.timestamp,u.username,co.commentcount  
					FROM " . TABLE_PREFIX . "umg_media AS m 
					LEFT JOIN " . TABLE_PREFIX. "umg_comment AS c ON (c.mediaid=m.mediaid) 
					LEFT JOIN " . TABLE_PREFIX . "umg_category AS ca ON (ca.catid=m.catid " . $search_timeshift . ") 
					LEFT JOIN " . TABLE_PREFIX . "umg_counts AS co ON (co.mediaid=m.mediaid) 
					LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid=m.userid) 
					WHERE u.userid=" . $userinfo['userid'] . "
					AND m.active=0 
					" . $only_private . "
					AND ca.catid IS NOT NULL 
					" . $and_query . "
					GROUP BY m.mediaid
					" . $order_by . "
					LIMIT " . $usettings['media_count']
				);
				if ($db->num_rows ($medias))
				{
					$row = $med = 0;
					while ($media = $db->fetch_array ($medias))
					{
						$w = $thumb_small_width . 'px';
						$h = $thumb_small_height . 'px';
						if ($size == 'm')
						{
							$w = $thumb_medium_width;
							$h = $thumb_medium_height;
						}

						if (!$row) $media_profile_bit .= "<tr valign=\"bottom\">\n";

						$mediaimage  = '<a href="umg.php?' . $session->vars['sessionurl'] . 'm=' . $media['mediaid'] . '">';
						$mediaimage .= '<img src="umg_view.php?' . $session->vars['sessionurl'] . 'do=' . $size . '&amp;mediaid=' . $media['mediaid'] . '" border="0" alt="' . $media['title'] . '" title="' . $media['title'] . '" />';
						$mediaimage .= '</a>';

						if ($profile['info'])
						{
							$dateline = vbdate ($vbulletin->options['dateformat'], $media['dateline'], 1) . ' ' . vbdate ($vbulletin->options['timeformat'], $media['dateline']);

							$rating = '&nbsp;';
							if ($media['votenum'])
							{
								$media['voteavg'] = vb_number_format ($media['votetotal'] / $media['votenum'], 2);
								$m_rating = round ($media['votetotal'] / $media['votenum']);
								$rating = "<img class=\"inlineimg\" src=\"$stylevar[imgdir_rating]/rating_$m_rating.gif\" alt=\"" . construct_phrase ($vbphrase['umg_rating_x_votes_y_average'], $media['votenum'], $media['voteavg']) . "\" border=\"0\" />";
							}

							$comments = 0;
							if ($media['comcount']) $comments = '<a href="umg.php?' . $session->vars['sessionurl'] . '&m=' . $media['mediaid'] . '#comments">' . $media['comcount'] . '</a>';
						}

						eval ('$media_profile_bit .= "' . fetch_template ('umgprofile_main_bit') . '";');
						$row++;
						if ($row == $media_row)
						{
							$row = 0;
							$media_profile_bit .= "</tr>\n";
						}
						$med++;
					}
					if ($row AND $med > $media_row)
					{
						for ($x = $row; $x < $media_row; $x++)
						{
							$media_profile_bit .= "<td>&nbsp;</td>\n";
						}
					}

					$title = $vbphrase['umg_profile_last_media'];
					if ($usettings['sort_by'] == 1)      $title = $vbphrase['umg_profile_best_rated'];
					else if ($usettings['sort_by'] == 2) $title = $vbphrase['umg_profile_most_hits'];
					else if ($usettings['sort_by'] == 3) $title = $vbphrase['umg_profile_most_comments'];

					eval ('$tpl_output = "' . fetch_template ('umgprofile_main') . '";');
				}
			}
		}

		$this->block_data['umg_profile'] = $tpl_output;
	}
}
?>